function Map(gameObject) {
	this.game = gameObject; // pointer to Game object, needed to setGameState
	this.image = null; // background image (need to be stored for events)
	this.bitmap = null; // background bitmap
	this.container = null; // map container
	this.traffic = null; // traffic ai
	this.pedestrians = [];
	this.buildings = [];
	this.cars = [];
}

Map.prototype.init = function(image) {
	this.image = image;
	this.bitmap = new createjs.Bitmap(image);

	if (this.bitmap != null) {
		/* loading city background */
		this.container = new createjs.Container();
		this.container.addChild(this.bitmap);
		this.container.x = -this.image.width / 3;
		this.container.y = -this.image.height / 3;

		this.traffic = new Traffic();

		var g = this.game;
		var w = this.image.width;
		var h = this.image.height;
		var container = this.container;

		// move map by left mouse click and drag
		this.bitmap.addEventListener("mousedown", function(evt) {
			var c = container;
			var offset = {
				x: c.x - evt.stageX,
				y: c.y - evt.stageY
			};
			evt.addEventListener("mousemove", function(e) {
				var canvas = document.getElementById("mainCanvas");
				if (e.stageX + offset.x <= 0 && e.stageX + offset.x >= -(w - canvas.width))
					c.x = e.stageX + offset.x;
				if (e.stageY + offset.y <= 0 && e.stageY + offset.y >= -(h - canvas.height))
					c.y = e.stageY + offset.y;
				g.mousePos = {
					x: 300,
					y: 300
				};
				g.mouseOldPos = {
					x: 300,
					y: 300
				};
				g.updateMinimap();
			});
			g.mousePos = {
				x: 300,
				y: 300
			};
			g.mouseOldPos = {
				x: 300,
				y: 300
			};
		}, true);
	}
}

Map.prototype.getContainer = function() {
	if (this.bitmap != null)
		return this.container;
	else
		return null;
}

Map.prototype.addBuilding = function(n, i, x, y, a, d) {
	var building = new Building(n, x, y, this.game, a, d);
	building.init(i);
	//this.buildings.push(building);
	this.buildings[n] = building;
	this.container.addChild(building.bitmap);
	building.bitmap.parent.addChild(building.bitmap); // force bitmap on top layer
}

Map.prototype.getBuilding = function(name) //id)
	{
		//return this.buildings[id];
		return this.buildings[name];
	}

Map.prototype.getBuildingById = function(id) {
	var buildings = jQuery.parseJSON(userdata['budynki']);
	for (var i in buildings) {
		var building = buildings[i];
		if (building.id == id)
			return this.buildings[i];
	}
	return null;
}

Map.prototype.addPedestrian = function(n, i, sx, sy, s, a) {
	// this code needs refactoring when there is more time
	var human = new Pedestrian(n, sx, sy, s, a);
	human.init(i);
	this.pedestrians.push(human);
	this.container.addChild(human.bitmap);
	human.bitmap.parent.addChild(human.bitmap);

	if (this.pedestrians.length <= 6) {
		var p = [];
		p.push({
			x: 937,
			y: 1030
		});
		p.push({
			x: 750,
			y: 923
		});
		p.push({
			x: 1050,
			y: 753
		});
		p.push({
			x: 1375,
			y: 940
		});
		p.push({
			x: 1230,
			y: 1026
		});
		p.push({
			x: 1090,
			y: 950
		});

		var sn = this.pedestrians.length - 1;

		human.bitmap.x = p[sn].x;
		human.bitmap.y = p[sn].y;
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient1(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("front");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("back");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p.length; i++) {
			tween.call(reorient1, [human.bitmap, dst]);
			tween.to({
				x: p[dst].x,
				y: p[dst].y
			}, calculateDistance(p[src].x, p[src].y, p[dst].x, p[dst].y) * s);
			if (src >= p.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}

	} else if (this.pedestrians.length <= 14) {
		var p2 = [];
		p2.push({
			x: 582,
			y: 1400
		});
		p2.push({
			x: 282,
			y: 1232
		});
		p2.push({
			x: 434,
			y: 1140
		});
		p2.push({
			x: 217,
			y: 1014
		});
		p2.push({
			x: 333,
			y: 952
		});
		p2.push({
			x: 711,
			y: 1179
		});
		p2.push({
			x: 896,
			y: 1068
		});
		p2.push({
			x: 1030,
			y: 1140
		});

		var sn = this.pedestrians.length - 6 - 1;

		human.bitmap.x = p2[sn].x; //0
		human.bitmap.y = p2[sn].y; //0
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p2.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient2(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("back");
			else if (dst == 4) bitmap.gotoAndPlay("right");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("right");
			else if (dst == 7) bitmap.gotoAndPlay("front");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p2.length; i++) {
			tween.call(reorient2, [human.bitmap, dst]);
			tween.to({
				x: p2[dst].x,
				y: p2[dst].y
			}, calculateDistance(p2[src].x, p2[src].y, p2[dst].x, p2[dst].y) * s);
			if (src >= p2.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p2.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	} else if (this.pedestrians.length <= 27) {
		var p3 = [];
		p3.push({
			x: 1420,
			y: 1313
		});
		p3.push({
			x: 1130,
			y: 1143
		});
		p3.push({
			x: 1423,
			y: 978
		});
		p3.push({
			x: 1483,
			y: 1016
		});
		p3.push({
			x: 1355,
			y: 1120
		});
		p3.push({
			x: 1485,
			y: 1165
		});
		p3.push({
			x: 1557,
			y: 1235
		});
		p3.push({
			x: 1720,
			y: 1145
		});
		p3.push({
			x: 1423,
			y: 978
		});
		p3.push({
			x: 1130,
			y: 1143
		});
		p3.push({
			x: 1285,
			y: 1235
		});
		p3.push({
			x: 1425,
			y: 1155
		});
		p3.push({
			x: 1557,
			y: 1235
		});

		var sn = this.pedestrians.length - 14 - 1;

		human.bitmap.x = p3[sn].x; //0
		human.bitmap.y = p3[sn].y; //0
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p3.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient3(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("front");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("front");
			else if (dst == 7) bitmap.gotoAndPlay("right");
			else if (dst == 8) bitmap.gotoAndPlay("back");
			else if (dst == 9) bitmap.gotoAndPlay("left");
			else if (dst == 10) bitmap.gotoAndPlay("front");
			else if (dst == 11) bitmap.gotoAndPlay("right");
			else if (dst == 12) bitmap.gotoAndPlay("front");
			else if (dst == 13) bitmap.gotoAndPlay("left");
			else if (dst == 14) bitmap.gotoAndPlay("back");

		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p3.length; i++) {
			tween.call(reorient3, [human.bitmap, dst]);
			tween.to({
				x: p3[dst].x,
				y: p3[dst].y
			}, calculateDistance(p3[src].x, p3[src].y, p3[dst].x, p3[dst].y) * s);
			if (src >= p3.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p3.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	} else if (this.pedestrians.length <= 37) {
		var p4 = [];
		p4.push({
			x: 1240,
			y: 1420
		});
		p4.push({
			x: 1110,
			y: 1352
		});
		p4.push({
			x: 1260,
			y: 1277
		});
		p4.push({
			x: 1082,
			y: 1176
		});
		p4.push({
			x: 947,
			y: 1262
		});
		p4.push({
			x: 1066,
			y: 1328
		});
		p4.push({
			x: 1124,
			y: 1286
		});
		p4.push({
			x: 1186,
			y: 1325
		});
		p4.push({
			x: 1270,
			y: 1287
		});
		p4.push({
			x: 1370,
			y: 1344
		});

		var sn = this.pedestrians.length - 27 - 1;

		human.bitmap.x = p4[sn].x;
		human.bitmap.y = p4[sn].y;
		human.bitmap.gotoAndPlay("back");

		var src = sn;
		var dst = sn + 1;
		if (dst > p4.length - 1) dst = 0;

		function calculateDistance(x1, y1, x2, y2) {
			return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
		};

		function reorient4(bitmap, dst) {
			if (dst == 0) bitmap.gotoAndPlay("left");
			else if (dst == 1) bitmap.gotoAndPlay("back");
			else if (dst == 2) bitmap.gotoAndPlay("right");
			else if (dst == 3) bitmap.gotoAndPlay("back");
			else if (dst == 4) bitmap.gotoAndPlay("left");
			else if (dst == 5) bitmap.gotoAndPlay("front");
			else if (dst == 6) bitmap.gotoAndPlay("right");
			else if (dst == 7) bitmap.gotoAndPlay("front");
			else if (dst == 8) bitmap.gotoAndPlay("right");
			else if (dst == 9) bitmap.gotoAndPlay("front");
		};

		var tween = createjs.Tween.get(human.bitmap, {
			loop: true
		}, true);

		for (i = 0; i < p4.length; i++) {
			tween.call(reorient4, [human.bitmap, dst]);
			tween.to({
				x: p4[dst].x,
				y: p4[dst].y
			}, calculateDistance(p4[src].x, p4[src].y, p4[dst].x, p4[dst].y) * s);
			if (src >= p4.length - 1) {
				src = 0;
			} else {
				src++;
			}
			if (dst >= p4.length - 1) {
				dst = 0;
			} else {
				dst++;
			}
		}
	}
}

Map.prototype.getPedestrian = function(id) {
	return this.pedestrians[id];
}

Map.prototype.addCar = function(n, i, sx, sy, s, a) {
	var car = new Car(n, sx, sy, s, a); // this.game, a
	car.init(i);
	this.cars.push(car);
	this.traffic.addCar(car);
	this.container.addChild(car.bitmap);
	car.bitmap.parent.addChild(car.bitmap); // force bitmap on top layer
}

Map.prototype.getCar = function(id) {
	return this.cars[id];
}

Map.prototype.addCloud = function(n, i, sx, sy, s, a) {
	var car = new Car(n, sx, sy, s, a);
	car.init(i);
	this.cars.push(car);
	// boat path
	this.container.addChild(car.bitmap);
	car.bitmap.parent.addChild(car.bitmap);

	var p1, p2, p3, p4, p5, p6, p7;

	if (n == "lodka") // -100 -40
	{ // x - 50
		p1 = {
			x: 1171,
			y: 1859
		};
		p2 = {
			x: 915,
			y: 1710
		};
		p3 = {
			x: 610,
			y: 1888
		};
		p4 = {
			x: 866,
			y: 2036
		};
		/*
		p1 = {x:1184,y:1964};
		p2 = {x:1028,y:1772};
		p3 = {x: 424,y:1840};
		p4 = {x: 380,y:2020};
		*/
	} else if (n == "lodka-2") // -100
	{
		p1 = {
			x: 382,
			y: 2074
		};
		p2 = {
			x: 585,
			y: 1957
		};
		p3 = {
			x: 243,
			y: 1757
		};
		p4 = {
			x: 39,
			y: 1874
		};
	} else if (n == "samolot") {
		p1 = {
			x: 3323,
			y: 485
		};
		p2 = {
			x: 4116,
			y: 18
		}; //4096,38
		p3 = {
			x: 3437,
			y: 418
		};
		p4 = {
			x: 3573,
			y: 501
		};
	} else if (n == "chmura1") {
		p1 = {
			x: 3448,
			y: 300
		};
		p2 = {
			x: 2000,
			y: 300
		};
		p3 = {
			x: 1744,
			y: 296
		};
		p4 = {
			x: -500,
			y: 850
		};
	} else if (n == "chmura2") {
		p1 = {
			x: 2640,
			y: 930
		};
		p2 = {
			x: 1700,
			y: 810
		};
		p3 = {
			x: 845,
			y: 1024
		};
		p4 = {
			x: -500,
			y: 1000
		};
	} else if (n == "chmura3") {
		p1 = {
			x: 2200,
			y: 1500
		};
		p2 = {
			x: 1600,
			y: 1500
		};
		p3 = {
			x: 400,
			y: 1700
		};
		p4 = {
			x: -500,
			y: 2000
		};
	} else if (n == "chmura4") {
		p1 = {
			x: 1500,
			y: 900
		};
		p2 = {
			x: 700,
			y: 1500
		};
		p3 = {
			x: 400,
			y: 1500
		};
		p4 = {
			x: -500,
			y: 2000
		};
	}

	car.bitmap.x = p1.x;
	car.bitmap.y = p1.y;
	car.bitmap.gotoAndPlay("northEast");

	function calculateDistance(x1, y1, x2, y2) {
		return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
	};

	var tween = createjs.Tween.get(car.bitmap, {
		loop: true
	}, true);
	if (n == "lodka") tween.call(function() {
		car.bitmap.gotoAndPlay("northWest")
	});
	// --- p1
	tween.to({
		x: p2.x,
		y: p2.y
	}, calculateDistance(p1.x, p1.y, p2.x, p2.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:-25},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("southWest")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("northWest")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("southWest")
	});
	// --- p2
	tween.to({
		x: p3.x,
		y: p3.y
	}, calculateDistance(p2.x, p2.y, p3.x, p3.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:45},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("southEast")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("southWest")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("southEast")
	});
	// --- p3
	if (n == "samolot")
		tween.to({
			x: p4.x,
			y: p4.y
		}, calculateDistance(p3.x, p3.y, p4.x, p4.y) * s * 7);
	else
		tween.to({
			x: p4.x,
			y: p4.y
		}, calculateDistance(p3.x, p3.y, p4.x, p4.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:-25},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("northEast")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("southEast")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("northWest")
	});
	// --- p4
	if (n == "samolot")
		tween.to({
			x: p1.x,
			y: p1.y
		}, calculateDistance(p4.x, p4.y, p1.x, p1.y) * s * 7);
	else
		tween.to({
			x: p1.x,
			y: p1.y
		}, calculateDistance(p4.x, p4.y, p1.x, p1.y) * s);
	if (n == "lodka") {
		//		tween.to({rotation:0},35*s);
		tween.call(function() {
			car.bitmap.gotoAndPlay("northWest")
		});
	}
	if (n == "lodka-2") {
		tween.call(function() {
			car.bitmap.gotoAndPlay("northEast")
		});
	}
	if (n == "samolot") tween.call(function() {
		car.bitmap.gotoAndPlay("northEast")
	});
}

Map.prototype.getImage = function() {
	return this.image;
}

Map.prototype.clearBuildingFilters = function() {
	for (index in window.game.map.buildings) {
		window.game.map.buildings[index].clearFilters();
	}
}
